#!/bin/bash
PARENT_DIR=$(realpath `dirname $0`)
$PARENT_DIR/checkrunninginstance.sh
if [ $? -eq 1 ]; then
    exit 1
fi

cd /var/opt/mssql
# If running as mssql execute the command, else sudo -u to mssql
if [ "$(id -u -n)" == "mssql" ]; then
    /opt/mssql/bin/sqlservr --setup -q$SQLSERVR_COLLATION
    retcode=$?
else
    sudo -u mssql /opt/mssql/bin/sqlservr --setup -q$SQLSERVR_COLLATION
    retcode=$?
fi
if [ $retcode -ne 0 ]; then
    exit 1
fi
exit 0
